async function getJob(slug: string) {
  const base = process.env.NEXT_PUBLIC_API_BASE || "https://app.maharah-hub.com";
  const res = await fetch(`${base}/api/public/jobs/${slug}`, { cache: "no-store" });
  if (!res.ok) return null;
  return res.json();
}

export default async function JobPage({ params }: { params: { slug: string } }) {
  const data = await getJob(params.slug);
  const job = data?.data;

  if (!job) {
    return (
      <div className="container">
        <a className="btn" href="/jobs">عودة</a>
        <div className="card">الوظيفة غير موجودة</div>
      </div>
    );
  }

  return (
    <div className="container">
      <a className="btn" href="/jobs">عودة</a>
      <div className="card">
        <h1 style={{marginTop:0}}>{job.title}</h1>
        <div className="row">
          {job.location_city && <span className="badge">{job.location_city}</span>}
          <span className="badge">{job.work_type}</span>
          <span className="badge">{job.employment_type}</span>
        </div>
        <p style={{whiteSpace:"pre-wrap"}}>{job.description || "—"}</p>
        <a className="btn btnPrimary" href="#">تقديم (سيتم ربط الفورم لاحقًا)</a>
      </div>
    </div>
  );
}
